# initpro-kassa-php-sdk

Библиотека для интеграции вашего сайта с облачным сервисом распределенной печати чеков [ИНИТПРО Касса](http://kassa.initpro.ru)

## Требования

* PHP >= 5.4
* CURL

## Установка

С помощью Composer:

```
composer require initpro/kassa-sdk
```

Вручную:

```
git clone git clone https://github.com/Initpro/initpro-kassa-php-sdk
```

```php
<?php

require __DIR__.'/initpro-kassa-php-sdk/autoload.php';
```

## Использование

Первым делом необходимо создать менеджер групп:
```php
<?php

use Initpro\KassaSdk\Client;
use Initpro\KassaSdk\GroupManager;

$key = 'идентификатор магазина';
$secret = 'секретный ключ';
// PSR-совместимый логгер (опциональный параметр)
$logger = null;
$client = new Client($key, $secret, $logger);
$manager = new GroupManager($client);
```

После чего зарегистрировать группы:

```php
$manager->registerGroup('group-name-1', 'group-id-1');
$manager->registerGroup('group-name-2', 'group-id-2');
// 'group-name-1' и 'group-name-2' - произвольные псевдомимы для обращения к группам касс.
// 'group-id-1' и 'group-id-2' - идентификаторы групп, созданных в личном кабинете.

```

Отправка чека на печать:

```php
<?php
use Initpro\KassaSdk\Check;
use Initpro\KassaSdk\Cashier;
use Initpro\KassaSdk\Payment;
use Initpro\KassaSdk\Position;
use Initpro\KassaSdk\TaxSystem;
use Initpro\KassaSdk\Vat;
use Initpro\KassaSdk\Exception\SdkException;

// уникальный ID, предоставляемый магазином
$checkID = 'id';
// E-Mail клиента, на который будет отправлен E-Mail с чеком.
$clientEmail = 'user@host';

$check = Check::createSell($checkID, $clientEmail, TaxSystem::COMMON); // или Check::createSellReturn для оформления возврата
// Говорим, что чек нужно распечатать
$check->setShouldPrint(true);

$vat = new Vat(Vat::RATE_18);

// Позиция в чеке: имя, цена, кол-во, общая стоимость, скидка, налог
$position = new Position('name', 100, 1, 100, 0, $vat);

// Опционально можно установить:
// Идентификатор позиции
// $position->setId('123');

// Единицу измерения
// $position->setMeasureName('Кг.');

// Cпособ рассчета
// $position->setCalculationMethod(CalculationMethod::FULL_PAYMENT);

// Признак рассчета
// $position->setCalculationSubject(CalculationSubject::PRODUCT);

// Агента по предмету расчета
// $agent = new Agent(Agent::COMMISSIONAIRE, "+77777777777", "ООО 'Лютик'", "12345678901");
// $position->setAgent($agent);

$check->addPosition($position);

// Итоговая сумма расчёта
$payment = new Payment(Payment::TYPE_CARD, 100);
$check->addPayment($payment);

// Добавление кассира (опционально)
$cashier = new Cashier('Иваров И.П.', '1234567890123');
$check->addCashier($cashier);

// Добавляем чек в группа.
try {
    $manager->putCheck($check, 'group-name-1');
} catch (SdkException $e) {
    echo $e->getMessage();
}
```

Отправка чека коррекции:

```php
<?php
use Initpro\KassaSdk\Correction;
use Initpro\KassaSdk\CorrectionCheck;
use Initpro\KassaSdk\AuthorisedPerson;
use Initpro\KassaSdk\Payment;
use Initpro\KassaSdk\Vat;
use Initpro\KassaSdk\TaxSystem;
use Initpro\KassaSdk\Exception\SdkException;

// Данные коррекции
// createSelf для самостоятельной коррекции
// createForced для коррекции по предписанию
$correction = Correction::createSelf(
    '2012-12-21', // Дата документа коррекции в формате yyyy-mm-dd
    '4815162342', // Номер документа коррекции
    'description' // Описание коррекции
);

// createSell для коррекции прихода
// createSellReturn для коррекции расхода
$check = CorrectionCheck::createSell(
    '4815162342', // Номер операции в вашей системе
    '4815162342', // Серийный номер принтера
    TaxSystem::COMMON, // Система налогообложения
    $correction // Данные коррекции
);

$check->setPayment(
    new Payment(Payment::TYPE_CARD, 4815), // Общая сумма по чеку
    new Vat('118') // Ставка налога
);

$authorised_person = new AuthorisedPerson(
  'Иваров И.И.', // ФИО
  '123456789012' // ИНН
);
$check->setAuthorisedPerson($authorised_person);

// Добавляем чек в группа.
try {
    $manager->putCheck($check, 'group-name-1');
} catch (SdkException $e) {
    echo $e->getMessage();
}

```

Чтобы не указывать каждый раз имя группы, установите группа по умолчанию:

```php
<?php

$manager->setDefaultGroup('group-name-1');
$manager->putCheck($check);
```


Получить состояние группы:

```php
<?php
$manager->isGroupActive('group-name-1');
```

Получить информацию о поставленной на фискализацию задаче:

```php
<?php
$taskManager = new TaskManager($client);
try {
    $taskManager->getTaskInfo('task-id');
} catch (SdkException $e) {
    echo $e->getMessage();
}
```