<?php

/**
 * This file is part of the initpro/kassa-sdk library
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

namespace Initpro\KassaSdk;

/**
* Признак рассчета
*/
class CalculationSubject
{
    /**
     * Товар, за исключением подакцизного товара
     */
    const PRODUCT = 'product';

    /**
     * Подакцизный товар
     */
    const PRODUCT_PRACTICAL = 'product_practical';

    /**
     * Работа
     */
    const WORK = 'work';

    /**
     * Услуга
     */
    const SERVICE = 'service';

    /**
     * Прием ставок при осуществлении деятельности по проведению азартных игр
     */
    const GAMBLING_BET = 'gambling_bet';

    /**
     * Выплата денежных средств в виде выигрыша при осуществлении деятельности по проведению
     * азартных игр
     */
    const GAMBLING_WIN = 'gambling_win';

    /**
     * Прием денежных средств при реализации лотерейных билетов, электронных лотерейных билетов,
     * приеме лотерейных ставок при осуществлении деятельности по проведению лотерей
     */
    const LOTTERY_BET = 'lottery_bet';

    /**
     * Выплате денежных средств в виде выигрыша при осуществлении деятельности по проведению
     * лотерей
     */
    const LOTTERY_WIN = 'lottery_win';

    /**
     * Предоставление прав на использование результатов интеллектуальной деятельности или средств
     * индивидуализации «ПРЕДОСТАВЛЕНИЕ РИД» или «РИД»
     */
    const RID = 'rid';

    /**
     * Об авансе, задатке, предоплате, кредите, взносе в счет оплаты, пени, штрафе, вознаграждении,
     * бонусе и ином аналогичном предмете расчета
     */
    const PAYMENT = 'payment';

    /**
     * Вознаграждении пользователя, являющегося платежным агентом (субагентом), банковским
     * платежным агентом (субагентом), комиссионером, поверенным или иным агентом
     */
    const COMMISSION = 'commission';

    /**
     * О предмете расчета, состоящем из предметов, каждому из которых может быть присвоено
     * значение от «0» до «11» (0-11 -- это вышеперечисленные)
     */
    const COMPOSITE = 'composite';

    /**
     * О предмете расчета, не относящемуся к предметам расчета, которым может быть присвоено
     * значение от «0» до «12» (0-12 -- это вышеперечисленные)
     */
    const OTHER = 'other';

}
