<?php


namespace InitproTest\KassaSdk;


use Initpro\KassaSdk\Agent;
use Initpro\KassaSdk\AuthorisedPerson;
use Initpro\KassaSdk\CalculationMethod;
use Initpro\KassaSdk\CalculationSubject;
use Initpro\KassaSdk\Cashier;
use Initpro\KassaSdk\Check;
use Initpro\KassaSdk\Client;
use Initpro\KassaSdk\Correction;
use Initpro\KassaSdk\CorrectionCheck;
use Initpro\KassaSdk\Exception\SdkException;
use Initpro\KassaSdk\Payment;
use Initpro\KassaSdk\Position;
use Initpro\KassaSdk\GroupManager;
use Initpro\KassaSdk\TaxSystem;
use Initpro\KassaSdk\Vat;

class IntegrationTest extends \PHPUnit_Framework_TestCase
{
    public function test()
    {
        $key = 'QGHWJbL';
        $secret = 'Y8dORbm2gKU1snJe';
        $logger = null;
        $client = new Client($key, $secret, $logger);
        $manager = new GroupManager($client);
        $manager->registerGroup('queue-name-1', 'iJbfC6ZH7A');
        $checkID = 'id10';
        $clientEmail = 'user@host.ru';

        $check = Check::createSell($checkID, $clientEmail, TaxSystem::COMMON);
        $check->setShouldPrint(false);

        $vat = new Vat(Vat::RATE_18);

        $position = new Position('Рис', 100, 1, 100, 0, $vat);

        $position->setId('123');

        $position->setMeasureName('Кг.');

        $position->setCalculationMethod(CalculationMethod::FULL_PAYMENT);

        $position->setCalculationSubject(CalculationSubject::PRODUCT);

        $agent = new Agent(Agent::COMMISSIONAIRE, "+77777777777", "ООО 'Лютик'", "7707083893");
        $position->setAgent($agent);

        $check->addPosition($position);

        $payment = new Payment(Payment::TYPE_CARD, 100);
        $check->addPayment($payment);

        $cashier = new Cashier('Иваров И.П.', '1234567890123');
        $check->addCashier($cashier);

        try {
            $manager->putCheck($check, 'queue-name-1');
        } catch (SdkException $e) {
            echo $e->getMessage();
        }
    }

    public function testCorrection()
    {
        $key = 'CpQmwrO';
        $secret = 'fZ6Jtqd8oER2PHMB';
        $logger = null;
        $client = new Client($key, $secret, $logger);
        $manager = new GroupManager($client);
        $manager->registerGroup('queue-name-1', 'aLZtyJnhBU');
        $correction = Correction::createSelf('2017-12-21', '4815162342', 'description');
        $check = CorrectionCheck::createSell('4815162346', '4815162342', TaxSystem::PATENT, $correction);
        $payment = new Payment(Payment::TYPE_CARD, 4815);
        $vat = new Vat('118');
        $check->setPayment($payment, $vat);
        $authorised_person = new AuthorisedPerson('Иваров И.И.', '123456789012');
        $check->setAuthorisedPerson($authorised_person);
        $manager->putCheck($check, 'queue-name-1');
    }
}