<?php

require_once __DIR__ . '/initpro-kassa-php-sdk/autoload.php';

use Initpro\KassaSdk\CalculationMethod;
use Initpro\KassaSdk\CalculationSubject;
use Initpro\KassaSdk\Check;
use Initpro\KassaSdk\Position;
use Initpro\KassaSdk\Vat;
use Initpro\KassaSdk\Client;
use Initpro\KassaSdk\GroupManager;
use Initpro\KassaSdk\Payment;
use Initpro\KassaSdk\Exception\ClientException;


class InitproHelper
{
    public static function fiscalize($order, $status, $params)
    {
        $taks_id = @$order['type_id'];
        if (!$taks_id) {
            $data = array(
                'order_id' => $order['order_id'],
                'type' => $order['type'],
                'status' => 'pending'
            );
            $taks_id = db_query('INSERT INTO ?:rus_initpro_kassa_order_fiscalization_status ?e', $data);
        }

        $uniqid = uniqid(strval($order['order_id']), true);

        $intent = $status === $params['status_refund']
            ? Check::INTENT_SELL_RETURN
            : Check::INTENT_SELL;

        $check = new Check($uniqid, $order['email'], $intent, intval($params['sno']));

        $calculationSubject = $params['calculation_subject'];
        $calculationSubjectDelivery = $params['calculation_subject_delivery'];

        if (
            $status == $params['status_refund']
            || $status == $params['status_full_payment']
        ) {
            $calculationMethod = CalculationMethod::FULL_PAYMENT;
            $paymentType = Payment::TYPE_CARD;
        }

        if ($status == $params['status_partial_prepayment']) {
            $calculationMethod = CalculationMethod::PRE_PAYMENT_FULL;
            $paymentType = Payment::TYPE_CARD;
            $calculationSubject = CalculationSubject::PAYMENT;
            $calculationSubjectDelivery = CalculationSubject::PAYMENT;
        }

        if ($status == $params['status_partial_full_payment']) {
            $calculationMethod = CalculationMethod::FULL_PAYMENT;
            $paymentType = Payment::TYPE_PREPAYMENT;
        }

        $total = floatval($order['total']);
        $subtotal = floatval($order['subtotal']) + floatval($order['shipping_cost']);

        $discount = $subtotal - $total;
        $delta = $discount / $subtotal;

        $calculatedTotal = 0;
        $positionsToAdd = [];
        $positions = $order['positions'];

        foreach ($positions as $position) {
            $productPrice = floatval($position['base_price'] * (1 - $delta));
            $productPriceTotal = $productPrice * floatval($position['amount']);

            $positionObj = new Position(
                $position['product'],
                round($productPrice, 2),
                floatval($position['amount']),
                round($productPriceTotal, 2),
                0,
                new Vat($params['vat'])
            );
            $positionObj->setCalculationSubject($calculationSubject);
            $positionObj->setCalculationMethod($calculationMethod);
            $positionObj->setMeasureName('шт.');

            $calculatedTotal += round($productPriceTotal, 2);
            $positionsToAdd[] = $positionObj;
        }

        if (round(floatval($order['shipping_cost']), 2) > 0.0) {
            $deliveryPrice = floatval($order['shipping_cost'] * (1 - $delta));

            $shippingPosition = new Position(
                "Доставка",
                round($deliveryPrice, 2),
                1,
                round($deliveryPrice, 2),
                0,
                new Vat($params['vat_delivery'])
            );
            $shippingPosition->setCalculationSubject($calculationSubjectDelivery);
            $shippingPosition->setCalculationMethod($calculationMethod);
            $shippingPosition->setMeasureName('шт.');

            $calculatedTotal += round($deliveryPrice, 2);
            $positionsToAdd[] = $shippingPosition;
        }

        if ($calculatedTotal != round($total, 2)) {
            $difference = round($total, 2) - $calculatedTotal;

            $positionToChange = array_shift($positionsToAdd);
            $positionToChange = $positionToChange->asArray();

            $positionNew = new Position(
                $positionToChange['name'],
                $positionToChange['price'] + $difference,
                1,
                $positionToChange['price'] + $difference,
                $positionToChange['discount'],
                new Vat($positionToChange['vat'])
            );
            $positionNew->setCalculationSubject($positionToChange['calculation_subject']);
            $positionNew->setCalculationMethod($positionToChange['calculation_method']);
            $positionNew->setMeasureName('шт.');

            array_unshift($positionsToAdd, $positionNew);

            if ($positionToChange['quantity'] > 1) {
                $positionNewAddition = new Position(
                    $positionToChange['name'],
                    $positionToChange['price'],
                    $positionToChange['quantity'] - 1,
                    round($positionToChange['price'] * ($positionToChange['quantity'] - 1), 2),
                    $positionToChange['discount'],
                    new Vat($positionToChange['vat'])
                );
                $positionNewAddition->setCalculationSubject($positionToChange['calculation_subject']);
                $positionNewAddition->setCalculationMethod($positionToChange['calculation_method']);
                $positionNewAddition->setMeasureName('шт.');

                array_unshift($positionsToAdd, $positionNewAddition);
            }
        }

        foreach ($positionsToAdd as $position) {
            $check->addPosition($position);
        }

        $payment = new Payment($paymentType, round($total, 2));

        $check->addPayment($payment);

        $client = new Client($params['shop_id'], $params['secret']);
        if (@$params['server_url']) {
            $client->setHost($params['server_url']);
        }

        $manager = new GroupManager($client);
        $manager->registerGroup('default', $params['queue_id']);
        $manager->setDefaultGroup('default');

        try {
            $manager->putCheck($check);
        } catch (ClientException $e) {
            $data = array(
                'status' => 'error',
                'description' => $e->getMessage()
            );
            fn_set_notification('W', fn_get_lang_var('warning'), '<pre>Initpro Kassa: ' . print_r($data, true) . '</pre>', true);
            db_query('UPDATE ?:rus_initpro_kassa_order_fiscalization_status SET ?u WHERE id = ?i', $data, $taks_id);
        }
    }
}
