<?php

use Tygh\Registry;
use Tygh\Settings;

require_once('Tygh/Addons/RusInitproKassa/initprohelper.php');

/**
 * Gets extra settings.
 *
 * @return array
 */
function fn_rus_initpro_kassa_get_settings()
{
    if (!Registry::isExist('rus_initpro_kassa.extra_settings')) {
        $settings = json_decode(Registry::get('addons.rus_initpro_kassa.extra'), true);

        if (!is_array($settings)) {
            $settings = array();
        }

        Registry::set('rus_initpro_kassa.extra_settings', $settings, false);
    }

    return (array) Registry::get('rus_initpro_kassa.extra_settings');
}

/**
 * Updates extra setting.
 *
 * @param string    $setting_name   Extra setting name
 * @param mixed     $value          Value
 */
function fn_rus_initpro_kassa_update_setting($setting_name, $value)
{
    $settings = fn_rus_initpro_kassa_get_settings();
    $settings[$setting_name] = $value;

    Registry::set(sprintf('rus_initpro_kassa.extra_settings.%s', $setting_name), $value);
    Settings::instance()->updateValue('extra', json_encode($settings), 'rus_initpro_kassa', false, false);
}

/**
 * Gets external payments.
 *
 * @return array
 */
function fn_rus_initpro_kassa_get_external_payments()
{
    return fn_get_schema('rus_initpro_kassa', 'payments');
}

/**
 * Gets payments external identifiers.
 *
 * @return array
 */
function fn_rus_initpro_kassa_get_external_payments_ids()
{
    $settings = fn_rus_initpro_kassa_get_external_payments();

    return isset($settings['payments_map']) ? $settings['payments_map'] : array();
}

/**
 * Sets payment external identifier.
 *
 * @param int  $payment_id  Local identifier
 * @param int  $external_id External identifier
 */
function fn_rus_initpro_kassa_set_payment_external_id($payment_id, $external_id)
{
    $external_payments = fn_rus_initpro_kassa_get_external_payments();
    $map = fn_rus_initpro_kassa_get_external_payments_ids();

    if (isset($external_payments[$external_id])) {
        $map[$payment_id] = $external_id;
    } else {
        unset($map[$payment_id]);
    }

    fn_rus_initpro_kassa_register_update_setting('payments_map', $map);
}

/**
 * Gets payment external identifier.
 *
 * @param int $payment_id Payment identifier
 *
 * @return int|null
 */
function fn_rus_initpro_kassa_get_payment_external_id($payment_id)
{
    $map = fn_rus_initpro_kassa_get_external_payments_ids();

    return isset($map[$payment_id]) ? $map[$payment_id] : null;
}

/**
 * Hook handler: after order status changed.
 *
 * @param string $status_to     Order status to
 * @param string $status_from   Order status from
 * @param array  $order_info    Order data
 */
function fn_rus_initpro_kassa_change_order_status($status_to, $status_from, $order_info)
{
    $paymentId = intval($order_info['payment_id']);
    $allowedPaymentIds = array_keys(Registry::get('addons.rus_initpro_kassa.payment_systems'));

    $subtotal = floatval($order_info['subtotal']);
    $total = floatval($order_info['total']);

    if (
        ($paymentId == 0 && $subtotal != 0 && $total == 0)
        || in_array($paymentId, $allowedPaymentIds)
    ) {
        $_rows = db_get_array('SELECT id,type FROM ?:rus_initpro_kassa_order_fiscalization_status WHERE order_id = ?i ORDER BY id DESC', intval($order_info['order_id']));
        $type_ids = array();
        foreach ($_rows as $_row) {
            if (!isset($type_ids[$_row['type']])) {
                $type_ids[$_row['type']] = $_row['id'];
            }
        }

        if ($order_info['order_id']) {
            $order = [
                'email' => $order_info['email'],
                'order_id' => intval($order_info['order_id']),
                'total' => $order_info['total'],
                'subtotal' => $order_info['subtotal'],
                'positions' => $order_info['products'],
                'shipping_cost' => $order_info['shipping_cost'],
                'full' => $order_info
            ];

            $params = [
                'sno' => Registry::get('addons.rus_initpro_kassa.default_sno'),
                'vat' => Registry::get('addons.rus_initpro_kassa.default_vat'),
                'vat_delivery' => Registry::get('addons.rus_initpro_kassa.default_vat_delivery'),
                'server_url' => Registry::get('addons.rus_initpro_kassa.server_url'),
                'shop_id' => Registry::get('addons.rus_initpro_kassa.shop_id'),
                'secret' => Registry::get('addons.rus_initpro_kassa.shop_secret'),
                'queue_id' => Registry::get('addons.rus_initpro_kassa.queue_id'),
                'status_full_payment' => Registry::get('addons.rus_initpro_kassa.status_full_payment'),
                'status_partial_prepayment' => Registry::get('addons.rus_initpro_kassa.status_partial_prepayment'),
                'status_partial_full_payment' => Registry::get('addons.rus_initpro_kassa.status_partial_full_payment'),
                'status_refund' => Registry::get('addons.rus_initpro_kassa.status_refund'),
                'calculation_subject' => Registry::get('addons.rus_initpro_kassa.calculation_subject'),
                'calculation_subject_delivery' => Registry::get('addons.rus_initpro_kassa.calculation_subject_delivery')
            ];

            $statuses = [
                $params['status_full_payment'],
                $params['status_partial_prepayment'],
                $params['status_partial_full_payment'],
                $params['status_refund'],
            ];

            if (in_array($status_to, $statuses)) {
                $helper = new InitproHelper();
                $helper->fiscalize($order, $status_to, $params);
            }
        }
    }
}
